# SaaS OS — Token Exports (Free Edition)

This folder contains machine-consumable design tokens exported from the SaaS OS Free Edition Figma source.

These files enable:
- Engineering implementation
- AI / Cursor-assisted development
- Visual consistency across projects
- Token-aligned UI styling

---

## Purpose

Tokens define the foundational design values used by SaaS OS components.

They include:
- Colors
- Spacing
- Radius
- Typography
- Motion (if applicable)

All UI styling must reference these tokens.

Hard rule:
Do not hardcode visual values (colors, spacing, radius, etc.) in application code.

---

## Source of Truth (Free Edition)

Authoritative order:

1. Figma Variables & Styles
2. `tokens.css`
3. `tokens.json`
4. `tokens.ts`

If a conflict exists between files in this folder, align with Figma and regenerate exports.

---

## Files

### `tokens.css`

- Runtime CSS variable layer
- Defines variables such as:
  - `--color-*`
  - `--space-*`
  - `--radius-*`
- Intended for direct use in applications and components

Example:

```css
color: var(--color-text-primary);
padding: var(--space-4);
```

Do not modify values manually unless the Figma source has been updated.

---

### `tokens.json`

- Structured representation of tokens
- Intended for tooling and automation
- Mirrors token categories from Figma

This file contains raw values only.
It does not include utilities or derived logic.

---

### `tokens.ts`

- Type-safe token bindings for TypeScript projects
- References CSS variables only
- Must not inline raw numeric or color values

Example usage:

```ts
import { tokens } from "@/tokens";

const styles = {
  color: tokens.color.text.primary,
  padding: tokens.space[4],
};
```

---

## Scope (Free Edition)

This folder reflects the token scope available in SaaS OS Free Edition.

Advanced token governance, theming strategies, and multi-mode systems are available in SaaS OS Pro.